% /************************************************************************
% * Name: readVector
% * Function: Read the Vector database.
% * Input: fDir: the directory of the file.
% *        cNum: the index of the character which need to be read.
% * Output: dat: the handwriting content of the corresponding characters
% * Return:
% * Explain:
% * Amendant record			
% * Date          Edition       Modifier      Summary
% * 20/11/2009    V1.0          Shusen Zhou   Establish 
% ************************************************************************/
function dat=readVector(fDir,cNum)
% Open file, read the number of the characters in the file.
   file_id = fopen(fDir, 'rb');   
   iNum=fread(file_id, 1, 'uint32');
   maxIndex=max(cNum);
   minIndex=min(cNum);
   if maxIndex>iNum
       disp('Error, the indexs are exceed the number of characters.');
       return;
   end
%  Applying Space
   dat=cell(1,length(cNum));
   iLenStr=zeros(1,iNum);
   iSpace=zeros(1,iNum);
%  Read the space of every character
   for i=1:iNum  
       iSpace(i)=fread(file_id, 1, 'uint16');                    
   end
%  Calculate the index of every character
   iIndex=zeros(1,iNum);
   iIndex(1)=iSpace(1);
   for i=2:iNum
       iIndex(i)=iIndex(i-1)+iSpace(i);
   end
%   Read all characters
   iTemp=0;
   for i=1:minIndex-1
       fread(file_id, iSpace(i), 'uint8');         
   end
   
   if minIndex==1
       datAll=fread(file_id, iIndex(maxIndex), 'uint8'); 
   else
       datAll=fread(file_id, iIndex(maxIndex)-iIndex(minIndex-1), 'uint8'); 
   end
    
   fclose(file_id);
   
%   extract the characters
    iLenStr(1)=datAll(1);
    iStart=iLenStr(1)+1+1;
    iSP=datAll(2:(iLenStr(1)+1));

    for i=1:length(cNum)
        if cNum(i)==1
            iAdd=0;
        elseif minIndex==1
            iAdd=iIndex(cNum(i)-1);            
        else
            iAdd=iIndex(cNum(i)-1)-iIndex(minIndex-1);
        end
        iLenStr(cNum(i))=datAll(iAdd+1);
        iCMov=iLenStr(cNum(i))+1;
        iSP=datAll(iAdd+2:iAdd+1+iLenStr(cNum(i)));
        fCTemp=cell(1,iLenStr(cNum(i)));
        for j=1:iLenStr(cNum(i))                      
            mTemp=sum(iSP(1:j-1))*2;            
            fCTemp{j}.X=datAll(iAdd+iCMov+mTemp+1:2:iAdd+iCMov+mTemp+iSP(j)*2)';
            fCTemp{j}.Y=datAll(iAdd+iCMov+mTemp+2:2:iAdd+iCMov+mTemp+iSP(j)*2)';
        end
        dat{i}=fCTemp;        
    end   
end

